### FedAsync

FedAsync is one of the first algorithms proposed in the literature towards operating federated learning training sessions in *asynchronous* mode, which Plato supports natively. It advocated aggregating aggressively whenever only *one* client reported its local updates to the server.

In its implementation, FedAsync's server subclasses from the `FedAvg` server and overrides its `configure()` and `aggregate_weights()` functions. In `configure()`, it needs to add some custom features (of obtaining a mixing hyperparameter for later use in the aggregation process), and calls `super().configure()` first, similar to its `__init__()` function calling `super().__init__()`. When it overrides `aggregate_weights()`, however, it supplied a completely custom implementation of this function.

```bash
cd examples/async/fedasync
uv run fedasync.py -c fedasync_MNIST_lenet5.yml
```

**Reference:** C. Xie, S. Koyejo, I. Gupta. "[Asynchronous Federated Optimization](https://opt-ml.org/papers/2020/paper_28.pdf)," in Proc. Annual Workshop on Optimization for Machine Learning (OPT), 2020.

---

### FedBuff

With over 400 citations based on Google Scholar, FedBuff is one of the widely cited asynchronous federated learning algorithms, and known for its simplicity. To run it:

```bash
cd examples/async/fedbuff
uv run fedbuff.py -c fedbuff_cifar10.yml
```

**Reference:** J. Nguyen et al. "[Federated Learning with Buffered Asynchronous Aggregation](https://arxiv.org/abs/2106.06639)," in Proc. AISTATS 2022.

---

### Port

Port is one of the newer asynchronous federated learning algorithms. The server will aggregate when it receives a minimum number of clients' updates, which can be tuned with 'minimum_clients_aggregated'. The 'staleness_bound' is also a common parameter in asynchronous FL, which limit the staleness of all clients' updates. 'request_update' is a special design in Port, to force clients report their updates and shut down the training process if their too slow. 'similarity_weight' and 'staleness_weight' are two hyper-parameters in Port, tuning the weights of them when the server do aggregation. 'max_sleep_time', 'sleep_simulation', 'avg_training_time' and 'simulation_distribution' are also important to define the arrival clients in Port.

```bash
cd examples/async/port
uv run port.py -c port_cifar10.yml
```

**Reference:** N. Su, B. Li. "[How Asynchronous can Federated Learning Be?](https://ieeexplore.ieee.org/document/9812885)," in Proc. IEEE/ACM International Symposium on Quality of Service (IWQoS), 2022.
